<?php

namespace App\Http\Controllers;

use App\Models\capacity;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CapacityController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $caps = capacity::getAll();
        return response()->json([
            "error" => false,
            "caps" => $caps
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'capacity' => ['required'],

                ]
            );
            $level = $request->input('level');
            $capacity = $request->input('capacity');

            $newCap = new capacity([
                'level' => $level,
                'capacity' => $capacity,
            ]);
            $res = $newCap->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "cap" => $newCap,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(int $id)
    {
        $thisCap = capacity::whereId($id)->get();
        if ($thisCap) {
            return response()->json([
                "error" => false, "cap" => $thisCap,
                "message" => "done"
            ]);
        } else {
            return response()->json(["error" => true, "message" => "Cant find"], 203);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(capacity $capacity)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'capacity' => ['required'],
                    'id' => ['required'],

                ]
            );
            $id = $request->input('id');
            $level = $request->input('level');
            $capacity = $request->input('capacity');

            $newCap = capacity::whereId($id)->get();
            $newCap->level = $level;
            $newCap->capacity = $capacity;
            $res = $newCap->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "cap" => $newCap,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'id' => ['required'],
                ]
            );
            $id =  $request->input('id');
            $res = capacity::whereId($id)->delete();
            return response()->json([
                "error" => false,
                "message" => "removed successfully. "
            ], 200);
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }
}
