<?php

namespace App\Http\Controllers;

use App\Models\dailySpin;
use Illuminate\Http\Request;

class DailySpinController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $dailySpins = dailySpin::getAll();
        return response()->json([
            "error" => false,
            "dailySpins" => $dailySpins
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'cost' => ['required'],
                    'hasWatch' => ['required'],

                ]
            );
            $level = $request->input('level');
            $cost = $request->input('cost');
            $hasWatch = $request->input('hasWatch');

            $newDailySpin = new dailySpin([
                'level' => $level,
                'cost' => $cost,
                'hasWatch' => $hasWatch,
            ]);
            $res = $newDailySpin->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "dailySpin" => $newDailySpin,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(int $id)
    {
        $thisCap = dailySpin::whereId($id)->get();
        if ($thisCap) {
            return response()->json([
                "error" => false,
                "dailySpin" => $thisCap,
                "message" => "done"
            ]);
        } else {
            return response()->json(["error" => true, "message" => "Cant find"], 203);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(dailySpin $dailySpin)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'cost' => ['required'],
                    'hasWatch' => ['required'],
                    'id' => ['required'],

                ]
            );
            $id = $request->input('id');
            $level = $request->input('level');
            $cost = $request->input('cost');
            $hasWatch = $request->input('hasWatch');


            $newDailySpin = dailySpin::whereId($id)->get();
            $newDailySpin->level = $level;
            $newDailySpin->cost = $cost;
            $newDailySpin->hasWatch = $hasWatch;
            $res = $newDailySpin->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "dailySpin" => $newDailySpin,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'id' => ['required'],
                ]
            );
            $id =  $request->input('id');
            $res = dailySpin::whereId($id)->delete();
            return response()->json([
                "error" => false,
                "message" => "removed successfully. "
            ], 200);
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }
}
