<?php

namespace App\Http\Controllers;

use Telegram\Bot\Api;
use Illuminate\Http\Request;
use App\Commands\StartCommand; // Replace with your commands

class TellConroller extends Controller
{
    public function handleWebhook(Request $request)
    {
        try {
            $telegram = new Api(env('TELEGRAM_BOT_TOKEN'));
            $updates = $telegram->getWebhookUpdates();

            // Process each update
            foreach ($updates as $update) {
                // Dispatch the update to the appropriate command
                $this->dispatchUpdate($update);
            }

            return 'OK';
        } catch (Exception $e) {
            Log::error('Telegram webhook error: ' . $e->getMessage());
            return response('Internal Server Error', 500);
        }
    }

    private function dispatchUpdate($update)
    {
        $message = $update->getMessage();

        if (isset($message)) {
            $command = $message->getText() ?? ''; // Handle commands and text messages

            foreach (config('telegram.commands') as $commandClass) {
                if ((new $commandClass)->is($command)) {
                    (new $commandClass)($telegram)->handle($update);
                    return;
                }
            }
            // Handle non-command messages here (optional)
        } else {
            // Handle other update types (callback queries, etc.) here
        }
    }
}
