<?php
///todo list : last tap time , referal

namespace App\Http\Controllers;

use App\Models\capacity;
use App\Models\dailySpin;
use App\Models\pertap;
use App\Models\spinchance;
use App\Models\spinvalues;
use App\Models\tellUser;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Json;
use Illuminate\Http\Request;

class TellUserController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $tellUsers = tellUser::getAll();
        return response()->json([
            "error" => false,
            "tellUsers" => $tellUsers
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     */
    public function register(Request $request)
    {
        try {
            $request->validate(
                [
                    'tellId' => ['required'],
                    // 'refId' => ['required']
                ]
            );
            $tellId = $request->input('tellId');
            $refId = $request->input('refId', null);

            $newTellUser = new tellUser([
                'tell_id' => $tellId,
                'ref_id' => $refId,
            ]);
            $newTellUser->save();
            $newTellUser = tellUser::find($newTellUser->id);
            if ($refId) {
                $refUser = tellUser::whereTellId($refId)->get()->first(); //first();
                if ($refUser->ref_limit > $refUser->used_ref) {
                    $refjson = $refUser->ref_json;
                    $newVal = ["gov" => 0, "local" => 10, "create_at" => Carbon::now(), "update_at" => Carbon::now()];
                    $refjson[$tellId] = $newVal;
                    $refUser->local_amount += 10;
                    $refUser->used_ref += 1;
                    $refUser->ref_json = $refjson;
                    $refUser->save();
                }
                return response()->json([
                    "error" => false,
                    "tellUser" => $newTellUser,
                    "refUser" => $refUser,
                    "message" => "done",
                    "condition" => $refUser->ref_limit > $refUser->used_ref,
                ]);
            } else {
                return response()->json([
                    "error" => false,
                    "tellUser" => $newTellUser,
                    "message" => "done"
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json(["error" => true, "message" => $th->getMessage()], 203);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
            ]
        );
        $tellId = $request->input('tellId');
        $thisTellUser = tellUser::whereTellId($tellId)->get()->first();
        $nowCarbon = Carbon::now();
        $lastTap = Carbon::parse($thisTellUser->last_tap);
        if (!$lastTap->isSameDay($nowCarbon->addDay())) {
            $thisTellUser->today_charge = 0;
        }
        if ($thisTellUser) {
            return response()->json([
                "error" => false,
                "tellUser" => $thisTellUser,
                "message" => "done"
            ]);
        } else {
            return response()->json(["error" => true, "message" => "Cant find"], 203);
        }
    }

    /**
     * Display the specified resource.
     */
    public function askReward(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
            ]
        );
        $tellId = $request->input('tellId');
        $thisTellUser = tellUser::whereTellId($tellId)->get()->first();
        if ($thisTellUser->get_reward == 0) {

            $thisTellUser->local_amount += 10;
            $thisTellUser->get_reward = 1;
            $thisTellUser->save();
            return response()->json(["error" => false, "message" => "Geted reward successfully!"], 200);
        } else {
            return response()->json(["error" => true, "message" => "Geted reward before!"], 203);
        }
    }

    /**
     * Display the specified resource.
     */
    public function showViaId(int $id)
    {
        $thisTellUser = tellUser::whereId($id)->get();
        if ($thisTellUser) {
            return response()->json([
                "error" => false,
                "tellUser" => $thisTellUser,
                "message" => "done"
            ]);
        } else {
            return response()->json(["error" => true, "message" => "Cant find"], 203);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(tellUser $tellUser)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'capacity' => ['required'],
                    'id' => ['required'],

                ]
            );
            $id = $request->input('id');
            $level = $request->input('level');
            $capacity = $request->input('capacity');

            $newTellUser = tellUser::whereId($id)->get();
            $newTellUser->level = $level;
            $newTellUser->capacity = $capacity;
            $res = $newTellUser->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "tellUser" => $newTellUser,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function setTaps(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
                'tap' => ['required'],
            ]
        );

        $tellId = $request->input('tellId');
        $tap = $request->input('tap');

        $newTellUser = tellUser::whereTellId($tellId)->get()->first(); //first()
        $nowCarbon = Carbon::now();
        $lastTap = Carbon::parse($newTellUser->last_tap);
        if (!$lastTap->isSameDay($nowCarbon->addDay())) {
            $newTellUser->today_charge = 0;
        }
        if ($newTellUser->today_charge < $newTellUser->capacity->capacity) {
            $value = $newTellUser->today_charge + $tap * $newTellUser->pertap->capacity;
            if ($value > $newTellUser->capacity->capacity) {
                $value = $newTellUser->capacity->capacity;
            }
            $income = $value -  $newTellUser->today_charge;
            $newTellUser->today_charge = $value;
            $newTellUser->local_amount += $income;
            $newTellUser->last_tap = $nowCarbon;

            $newTellUser->save();
            //referal!
            if ($newTellUser->ref_id) {
                $refUser = tellUser::whereTellId($newTellUser->ref_id)->get()->first(); //first();
                if ($refUser) {

                    $refjson = $refUser->ref_json;
                    if (isset($refjson[$tellId])) {
                        $newVal = $refjson[$tellId];
                        $newVal["local"] += floor($income / 10);
                        $newVal["update_at"] = Carbon::now();
                        $refjson[$tellId] = $newVal;
                        $refUser->local_amount += floor($income / 10);
                    } else {
                    }

                    $refUser->ref_json = $refjson;
                    $refUser->save();
                    return response()->json(["error" => false, "message" => "updated", "user" => $newTellUser, "value" => $value, "ref" => $refUser], 200);
                }
            }
            return response()->json(["error" => false, "message" => "updated", "user" => $newTellUser, "value" => $value], 200);
        } else {
            return response()->json(["error" => true, "message" => "todays capacity is over", "user" => $newTellUser], 202);
        }
    }

    public function getBoostInfo(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
            ]
        );

        $tellId = $request->input('tellId');

        $newTellUser = tellUser::whereTellId($tellId)->get()->first(); //first()
        $nextCap = capacity::find($newTellUser->capacity_id + 1); // change them to level!
        $nextPerTap = pertap::find($newTellUser->pertap_id + 1);
        $nextSpin = dailySpin::find($newTellUser->daily_spin_id + 1);
        return response()->json(["error" => false, "message" => "done!", "capacity" => $nextCap, "pertap" => $nextPerTap, "spin" => $nextSpin], 200);
    }

    public function askBoost(Request $request)
    {
        $request->validate(
            [
                'type' => ['required'],
                'tellId' => ['required'],
            ]

        );
        $type =   $request->input('type');
        $tellId = $request->input('tellId');
        $newTellUser = tellUser::whereTellId($tellId)->get()->first();

        $nextPerTap = pertap::find($newTellUser->pertap_id + 1);
        $nextSpin = dailySpin::find($newTellUser->daily_spin_id + 1);
        if ($type == 'capacity') {
            $nextCap = capacity::find($newTellUser->capacity->id + 1);
            if ($newTellUser->local_amount > $nextCap->cost) {
                $newTellUser->local_amount -= $nextCap->cost;
                $newTellUser->capacity_id = $nextCap->id;
                $newTellUser->save();
                return response()->json(["error" => false, "message" => "done!", "capacity" => $nextCap, "user" => $newTellUser,], 200);
            } else {
                return response()->json(["error" => true, "message" => "not enough token!",], 400);
            }
        } else  if ($type == 'pertap') {
            $nextPerTap = capacity::find($newTellUser->pertap->id + 1);
            if ($newTellUser->local_amount > $nextPerTap->cost) {
                $newTellUser->local_amount -= $nextPerTap->cost;
                $newTellUser->capacity_id = $nextPerTap->id;
                $newTellUser->save();
                return response()->json(["error" => false, "message" => "done!", "pertap" => $nextPerTap, "user" => $newTellUser,], 200);
            } else {
                return response()->json(["error" => true, "message" => "not enough token!",], 400);
            }
        } else if ($type == 'charge') {
            $cap = $newTellUser->capacity;
            if ($newTellUser->local_amount > 100) {
                $newTellUser->local_amount -= 100;
                $newTellUser->today_charge = 0;
                $newTellUser->save();
                return response()->json(["error" => false, "message" => "done!", "user" => $newTellUser,], 200);
            } else {
                return response()->json(["error" => true, "message" => "not enough token!",], 400);
            }
        } else  if ($type == 'spin') {
        } else if ($type == 'referal') {
        } else {
            return response()->json(["error" => true, "message" => "unknown boost!",], 400);
        }
    }

    public function spin(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
            ]
        );

        $tellId = $request->input('tellId');

        $newTellUser = tellUser::whereTellId($tellId)->get()->first(); //first()
        if (!$newTellUser->is_used_spin) {
            $newTellUser->is_used_spin = true;
            if ($newTellUser->govern_amount == 0) { //chance 1
                $thisChance = spinchance::find(1);
                $gov = $thisChance->gov;
                $good = $thisChance->good;
                $firstVal = random_int(0, 100) < $gov ? 0 : 18;
                $secVal = random_int(0, 100) < $good ? 0 : 9;
                $thirdVal = random_int(0, 9);
                $result = $firstVal + $secVal + $thirdVal;
                $values = spinvalues::find(1);
                $reward = $values[$result];
                if (!$firstVal) {
                    $newTellUser->govern_amount += $reward;
                } else {
                    $newTellUser->local_amount += $reward;
                }
                return response()->json(["error" => false, 'user' => $newTellUser, 'values' => $values, 'result' => $result, 'reward' => $reward], 200);
            } else if ($newTellUser->govern_amount < 1) {
                $thisChance = spinchance::find(2);
            } else if ($newTellUser->govern_amount < 5) {
                $thisChance = spinchance::find(3);
            } else if ($newTellUser->govern_amount < 10) {
                $thisChance = spinchance::find(4);
            }
            $gov = $thisChance->gov;
            $good = $thisChance->good;
            $firstVal = random_int(0, 100) < $gov ? 0 : 18;
            $secVal = random_int(0, 100) < $good ? 0 : 9;
            $thirdVal = random_int(0, 9);
            $result = $firstVal + $secVal + $thirdVal;
            $newIndex = $newTellUser->daily_spin_id % (dailySpin::count() - 1) + 1;
            $values = spinvalues::find($newIndex);
            $reward = $values[$result];
            if (!$firstVal) {
                $newTellUser->govern_amount += $reward;
            } else {
                $newTellUser->local_amount += $reward;
            }
            return response()->json(["error" => false, 'user' => $newTellUser, 'values' => $values, 'result' => $result, 'reward' => $reward], 200);
        } else {
            return response()->json(["error" => true, "message" => "used spinner before !",], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'id' => ['required'],
                ]
            );
            $id =  $request->input('id');
            $res = tellUser::whereId($id)->delete();
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }
}


//{"1":5,"2":4.5,"3":4,"4":3.5,"5":3,"6":2.5,"7":2,"8":1.5,"9":1,"10":0.95,"11":0.9,"12":0.85,"13":0.80,"14":0.75,"15":0.7,"16":0.65,"17":0.6,"18":0.5,"19":5,"20":4.5,"21":4,"22":3.5,"23":3,"24":2.5,"25":2,"26":1.5,"27":1,"28":0.95,"29":0.9,"30":0.85,"31":0.80,"32":0.75,"33":0.7,"34":0.65,"35":0.6,"36":0.5}