<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations. 
     */
    public function up(): void
    {
        Schema::create('tell_users', function (Blueprint $table) {
            $table->id();
            $table->string('tellId');
            $table->string('name')->nullable();
            $table->string('phone')->nullable();
            $table->foreignId('exchange_id')->constrained()->default(1);
            $table->string('uid')->nullable();
            $table->string('link')->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tell_users');
    }
};
